//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
//---------------------------------------------------------------------------
USERES("FileAssociation1.res");
USEFORM("MainU.cpp", Form1);
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR cmdLine, int)
{
  try {
    // Try to open the mutex.
    HANDLE hMutex = OpenMutex(MUTEX_ALL_ACCESS, 0, "MyApp1.0");

    // If hMutex is 0 then the mutex doesn't exist. Create it.
    if (!hMutex)
      hMutex = CreateMutex(0, 0, "MyApp1.0");
    else {
      // This is a second instance. Bring the original
      // instance to the top.
      HWND hWnd = FindWindow(0, "File Association Example");
      SetForegroundWindow(hWnd);

      // Command line is not empty. Send the command line
      // in a WM_COPYDATA message.
      if (strlen(cmdLine) != 0) {

        COPYDATASTRUCT cds;
        cds.cbData = strlen(cmdLine) + 1;
        cds.lpData = cmdLine;
        SendMessage(hWnd, WM_COPYDATA, 0, (LPARAM)&cds);
      }
      return 0;
    }

    Application->Initialize();
    Application->CreateForm(__classid(TForm1), &Form1);
    Application->Run();

    ReleaseMutex(hMutex);
  }
  catch (Exception &exception) {
    Application->ShowException(&exception);
  }
  return 0;
}
//---------------------------------------------------------------------------
